# -*- coding: utf-8 -*-

# Simple
# More: http://lazov.ru/rqg/tutorial.php?name=create_plugin_game

import os, sys, io, struct
from PIL import Image
import numpy as np

NAME = "Simple" # Group name
FORMATS_ARCHIVE = ['dat'] # List of supported archive formats
TYPES_ARCHIVE = [('Simple Pack', ('*.dat'))] # Types of files in the "Open archive" window
GAMES = ["Simple Game 1", # List of group games
         "Simple Game 2"]
AUTHOR = "Author author@email.com" # About the author

class Game_Res:
    def __init__(self,api):
        self.file = None
        self.data = [] # List of tuples or lists: (resource name, offset, size, format, ...)
        
        # Supported formats from the archive
        self.sup_formats = ["png",
                            "anm",
                            "wav"]
        # Types of resources
        # 1 - Image, 2 - Animation, 3 - Sound
        self.sup_types = {"png":1,
                          "anm":2,
                          "wav":3}
        self.images = []   # Array of Images PIL.Image | []
        self.sound = None  # Buffer with sound | io.BytesIO(bytes)

    # Функция Открытия архива
    # Arguments:
        # file - Путь до архива | str
    def open_data(self,file):
        format = file.split(".")[-1].lower()
        if format == "dat":
            self.OpenArchiveDAT(file)
    
    # Функция Распаковки ресурсов
    # Arguments:
        # data_res - [(resource name, offset, size, format, ...), ...]
    def unpack(self,data_res):
        self.images = []
        self.sound = None
        
        name = data_res[0]
        offset = data_res[1]
        size = data_res[2]
        format = data_res[3]
        self.file.seek(offset)
        if format == "png":
            self.Unpack_PNG(io.BytesIO(self.file.read(size)))
        elif format == "anm":
            self.Unpack_ANM(io.BytesIO(self.file.read(size)))
        elif format == "wav":
            self.Unpack_WAV(io.BytesIO(self.file.read(size)))

    def OpenArchiveDAT(self,file):

        self.file = open(file,"rb")
        num_files = struct.unpack("<I",f.read(4))[0] # Number of files

        for i in range(num_files):
            filename = f.read(32)
            filename = filename.split(b"\x00")[0].decode("utf8")
            format = filename.split(".")[-1].lower()
            offset = struct.unpack("<I",f.read(4))[0]
            size = struct.unpack("<I",f.read(4))[0]
            self.data.append((filename,offset,size,format))

    def Unpack_PNG(self, f):
        image = Image.open(f)
        self.images = [image]

    def Unpack_WAV(self, f):
        self.sound = f

    def Unpack_ANM(self,f):
        num_frames = struct.unpack("<I",f.read(4))[0]
        for i in range(num_frames):
            rgb = []
            w = struct.unpack("<I",f.read(4))[0]
            h = struct.unpack("<I",f.read(4))[0]
            for j in range(w*h):
                p = struct.unpack("4B",f.read(3))
                rgb.extend(p)
            rgb = np.array(rgb,np.uint8).reshape(h, w, 3)
            self.images.append(Image.fromarray(rgb,"RGB"))
        
        