﻿#!/usr/bin/env python3
# -*- coding: utf-8 -*-

import os, sys, struct
from PIL import Image
import array

NAME = "Simple" # Имя в программе

class Anm_Exp:
    def __init__(self, exapp, images, path, name):
        self.exapp = exapp
        
        self.images = images # Кадры | список объектов PIL
        self.path = path # Путь сохраенния анимации, заданный пользователем
        self.name = name # Имя ресурса

    # Функция сохранения
    def save(self):
        f = open(self.path+"\\"+self.name+".anm", "wb")
        
        for i in range(len(self.images)):
            im = self.images[i]
            
            w=im.size[0]
            h=im.size[1]
            f.write(struct.pack("<II", w, h)) # Записываем ширину и высоту
            
            rgb = im.getdata()

            for j in range(w*h):
                f.write(struct.pack("3B", rgb[j][0], rgb[j][1], rgb[j][2])) # Записывает данные в формате RGB

        f.close()